<?php //b2aa02d5fa5ccd369be10c68788cbab2
/** @noinspection all */

namespace Modules\TaxModule\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_City_C;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_City_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_Country_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_State_C;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_State_QB;
    use LaravelIdea\Helper\Modules\TaxModule\Entities\_IH_CountryTax_C;
    use LaravelIdea\Helper\Modules\TaxModule\Entities\_IH_CountryTax_QB;
    use LaravelIdea\Helper\Modules\TaxModule\Entities\_IH_StateTax_C;
    use LaravelIdea\Helper\Modules\TaxModule\Entities\_IH_StateTax_QB;
    use LaravelIdea\Helper\Modules\TaxModule\Entities\_IH_TaxClassOption_C;
    use LaravelIdea\Helper\Modules\TaxModule\Entities\_IH_TaxClassOption_QB;
    use LaravelIdea\Helper\Modules\TaxModule\Entities\_IH_TaxClass_C;
    use LaravelIdea\Helper\Modules\TaxModule\Entities\_IH_TaxClass_QB;
    use Modules\CountryManage\Entities\City;
    use Modules\CountryManage\Entities\Country;
    use Modules\CountryManage\Entities\State;
    
    /**
     * @property int $id
     * @property int $country_id
     * @property float $tax_percentage
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Country $country
     * @method BelongsTo|_IH_Country_QB country()
     * @method static _IH_CountryTax_QB onWriteConnection()
     * @method _IH_CountryTax_QB newQuery()
     * @method static _IH_CountryTax_QB on(null|string $connection = null)
     * @method static _IH_CountryTax_QB query()
     * @method static _IH_CountryTax_QB with(array|string $relations)
     * @method _IH_CountryTax_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CountryTax_C|CountryTax[] all()
     * @ownLinks country_id,\Modules\CountryManage\Entities\Country,id
     * @mixin _IH_CountryTax_QB
     */
    class CountryTax extends Model {}
    
    /**
     * @property int $id
     * @property int $state_id
     * @property int $country_id
     * @property float $tax_percentage
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property State $state
     * @method BelongsTo|_IH_State_QB state()
     * @method static _IH_StateTax_QB onWriteConnection()
     * @method _IH_StateTax_QB newQuery()
     * @method static _IH_StateTax_QB on(null|string $connection = null)
     * @method static _IH_StateTax_QB query()
     * @method static _IH_StateTax_QB with(array|string $relations)
     * @method _IH_StateTax_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StateTax_C|StateTax[] all()
     * @ownLinks state_id,\Modules\CountryManage\Entities\State,id|country_id,\Modules\CountryManage\Entities\Country,id
     * @mixin _IH_StateTax_QB
     */
    class StateTax extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_TaxClassOption_C|TaxClassOption[] $classOption
     * @property-read int $class_option_count
     * @method HasMany|_IH_TaxClassOption_QB classOption()
     * @method static _IH_TaxClass_QB onWriteConnection()
     * @method _IH_TaxClass_QB newQuery()
     * @method static _IH_TaxClass_QB on(null|string $connection = null)
     * @method static _IH_TaxClass_QB query()
     * @method static _IH_TaxClass_QB with(array|string $relations)
     * @method _IH_TaxClass_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TaxClass_C|TaxClass[] all()
     * @foreignLinks id,\Modules\TaxModule\Entities\TaxClassOption,class_id|id,\Modules\Product\Entities\Product,tax_class_id
     * @mixin _IH_TaxClass_QB
     */
    class TaxClass extends Model {}
    
    /**
     * @property int $id
     * @property int $class_id
     * @property string $tax_name
     * @property int|null $country_id
     * @property int|null $state_id
     * @property int|null $city_id
     * @property string|null $postal_code
     * @property int $priority
     * @property bool|null $is_compound
     * @property bool|null $is_shipping
     * @property float $rate
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_City_C|City[] $cities
     * @property-read int $cities_count
     * @method HasMany|_IH_City_QB cities()
     * @property City|null $city
     * @method BelongsTo|_IH_City_QB city()
     * @property Country|null $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property State|null $state
     * @method BelongsTo|_IH_State_QB state()
     * @property _IH_State_C|State[] $states
     * @property-read int $states_count
     * @method HasMany|_IH_State_QB states()
     * @property TaxClass $taxClass
     * @method BelongsTo|_IH_TaxClass_QB taxClass()
     * @method static _IH_TaxClassOption_QB onWriteConnection()
     * @method _IH_TaxClassOption_QB newQuery()
     * @method static _IH_TaxClassOption_QB on(null|string $connection = null)
     * @method static _IH_TaxClassOption_QB query()
     * @method static _IH_TaxClassOption_QB with(array|string $relations)
     * @method _IH_TaxClassOption_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TaxClassOption_C|TaxClassOption[] all()
     * @ownLinks class_id,\Modules\TaxModule\Entities\TaxClass,id|country_id,\Modules\CountryManage\Entities\Country,id|state_id,\Modules\CountryManage\Entities\State,id|city_id,\Modules\CountryManage\Entities\City,id
     * @mixin _IH_TaxClassOption_QB
     */
    class TaxClassOption extends Model {}
}