<?php //856e2f5a16b11eff6c72897742f3009f
/** @noinspection all */

namespace Modules\Wallet\Entities {

    use App\Models\Tenant;
    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Tenant_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletHistory_C;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletHistory_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletSettings_C;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletSettings_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletTenantList_C;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletTenantList_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_Wallet_C;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_Wallet_QB;

    /**
     * @property int $id
     * @property int $user_id
     * @property float $balance
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $unique_key
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property WalletSettings $walletSettings
     * @method HasOne|_IH_WalletSettings_QB walletSettings()
     * @method static _IH_Wallet_QB onWriteConnection()
     * @method _IH_Wallet_QB newQuery()
     * @method static _IH_Wallet_QB on(null|string $connection = null)
     * @method static _IH_Wallet_QB query()
     * @method static _IH_Wallet_QB with(array|string $relations)
     * @method _IH_Wallet_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Wallet_C|Wallet[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Wallet_QB
     */
    class Wallet extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property string|null $payment_gateway
     * @property string|null $payment_status
     * @property float $amount
     * @property string|null $transaction_id
     * @property string $manual_payment_image
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_WalletHistory_QB onWriteConnection()
     * @method _IH_WalletHistory_QB newQuery()
     * @method static _IH_WalletHistory_QB on(null|string $connection = null)
     * @method static _IH_WalletHistory_QB query()
     * @method static _IH_WalletHistory_QB with(array|string $relations)
     * @method _IH_WalletHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WalletHistory_C|WalletHistory[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_WalletHistory_QB
     */
    class WalletHistory extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property bool|null $renew_package
     * @property bool|null $wallet_alert
     * @property float|null $minimum_amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_WalletSettings_QB onWriteConnection()
     * @method _IH_WalletSettings_QB newQuery()
     * @method static _IH_WalletSettings_QB on(null|string $connection = null)
     * @method static _IH_WalletSettings_QB query()
     * @method static _IH_WalletSettings_QB with(array|string $relations)
     * @method _IH_WalletSettings_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WalletSettings_C|WalletSettings[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_WalletSettings_QB
     */
    class WalletSettings extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property string $tenant_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Tenant $tenant
     * @method BelongsTo|_IH_Tenant_QB tenant()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_WalletTenantList_QB onWriteConnection()
     * @method _IH_WalletTenantList_QB newQuery()
     * @method static _IH_WalletTenantList_QB on(null|string $connection = null)
     * @method static _IH_WalletTenantList_QB query()
     * @method static _IH_WalletTenantList_QB with(array|string $relations)
     * @method _IH_WalletTenantList_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WalletTenantList_C|WalletTenantList[] all()
     * @ownLinks user_id,\App\Models\User,id|tenant_id,\App\Models\Tenant,id
     * @mixin _IH_WalletTenantList_QB
     */
    class WalletTenantList extends Model {}
}
