<?php //f80f887222e7c477f3b783c55e42d991
/** @noinspection all */

namespace Modules\DomainReseller\Entities {

    use App\Models\Tenant;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Tenant_C;
    use LaravelIdea\Helper\App\Models\_IH_Tenant_QB;
    use LaravelIdea\Helper\Modules\DomainReseller\Entities\_IH_DomainPaymentLog_C;
    use LaravelIdea\Helper\Modules\DomainReseller\Entities\_IH_DomainPaymentLog_QB;
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $tenant_id
     * @property string $first_name
     * @property string $last_name
     * @property string $email
     * @property string $phone
     * @property string|null $user_details It will contain all data of the user converted into json
     * @property string $ip_address User ip address
     * @property string $domain
     * @property float $domain_price
     * @property float $extra_fee
     * @property int $period
     * @property bool $privacy
     * @property string|null $payment_gateway
     * @property bool $payment_status
     * @property bool $status false means drafted and true means active
     * @property string|null $custom_field
     * @property string|null $track
     * @property string|null $contact_billing
     * @property string|null $contact_registrant
     * @property string|null $contact_tech
     * @property string|null $unique_key
     * @property int $purchase_count
     * @property Carbon|null $expire_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Tenant $paymentable_tenant
     * @method HasOne|_IH_Tenant_QB paymentable_tenant()
     * @property _IH_Tenant_C|Tenant[] $tenants
     * @property-read int $tenants_count
     * @method BelongsToMany|_IH_Tenant_QB tenants()
     * @method static _IH_DomainPaymentLog_QB onWriteConnection()
     * @method _IH_DomainPaymentLog_QB newQuery()
     * @method static _IH_DomainPaymentLog_QB on(null|string $connection = null)
     * @method static _IH_DomainPaymentLog_QB query()
     * @method static _IH_DomainPaymentLog_QB with(array|string $relations)
     * @method _IH_DomainPaymentLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DomainPaymentLog_C|DomainPaymentLog[] all()
     * @ownLinks user_id,\App\Models\User,id|tenant_id,\App\Models\Tenant,id
     * @mixin _IH_DomainPaymentLog_QB
     */
    class DomainPaymentLog extends Model {}
}