<?php //95180d3cef1e414fbe2b1ae7bd89185e
/** @noinspection all */

namespace App\Events {

    use App\Models\User;
    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch($message)
     * @method static PendingBroadcast broadcast($message)
     */
    class SupportMessage {}
    
    /**
     * @method static void dispatch(array $cronjob_info)
     * @method static PendingBroadcast broadcast(array $cronjob_info)
     */
    class TenantCronjobEvent {}
    
    /**
     * @method static void dispatch(array $notification_info)
     * @method static PendingBroadcast broadcast(array $notification_info)
     */
    class TenantNotificationEvent {}
    
    /**
     * @method static void dispatch(User $user, $subdomain, $theme = 'hexfashion')
     * @method static PendingBroadcast broadcast(User $user, $subdomain, $theme = 'hexfashion')
     */
    class TenantRegisterEvent {}
}

namespace App\Jobs {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Stancl\Tenancy\Contracts\TenantWithDatabase;
    
    /**
     * @method static PendingDispatch dispatch(TenantWithDatabase $tenant)
     * @method static mixed dispatchNow(TenantWithDatabase $tenant)
     * @method static mixed dispatchSync(TenantWithDatabase $tenant)
     */
    class NewShopCreatedEmailNotificationJob {}
    
    /**
     * @method static PendingDispatch dispatch($details)
     * @method static mixed dispatchNow($details)
     * @method static mixed dispatchSync($details)
     */
    class PlaceOrderMailJob {}
    
    /**
     * @method static PendingDispatch dispatch($days_reaming, $paymentLog)
     * @method static mixed dispatchNow($days_reaming, $paymentLog)
     * @method static mixed dispatchSync($days_reaming, $paymentLog)
     */
    class SendAccountRemoveMailJob {}
    
    /**
     * @method static PendingDispatch dispatch($days_reaming, $paymentLog)
     * @method static mixed dispatchNow($days_reaming, $paymentLog)
     * @method static mixed dispatchSync($days_reaming, $paymentLog)
     */
    class SendPackageExpireEmailJob {}
    
    /**
     * @method static PendingDispatch dispatch($file, $tenant_id)
     * @method static mixed dispatchNow($file, $tenant_id)
     * @method static mixed dispatchSync($file, $tenant_id)
     */
    class SyncFileForNewTenantJob {}
    
    /**
     * @method static PendingDispatch dispatch($file)
     * @method static mixed dispatchNow($file)
     * @method static mixed dispatchSync($file)
     */
    class SyncLocalFileWithCloud {}
    
    /**
     * @method static PendingDispatch dispatch($item, $tenant_id)
     * @method static mixed dispatchNow($item, $tenant_id)
     * @method static mixed dispatchSync($item, $tenant_id)
     */
    class SyncTenantLocalFileWithCloud {}
    
    /**
     * @method static PendingDispatch dispatch(string $pathname, string $tenantId)
     * @method static mixed dispatchNow(string $pathname, string $tenantId)
     * @method static mixed dispatchSync(string $pathname, string $tenantId)
     */
    class TenanFileCopyFromCloudForNewTenant {}
    
    /**
     * @method static PendingDispatch dispatch($tenant)
     * @method static mixed dispatchNow($tenant)
     * @method static mixed dispatchSync($tenant)
     */
    class TenandOperations {}
    
    /**
     * @method static PendingDispatch dispatch($details)
     * @method static mixed dispatchNow($details)
     * @method static mixed dispatchSync($details)
     */
    class TenantCredentialJob {}
    
    /**
     * @method static PendingDispatch dispatch(TenantWithDatabase $tenant)
     * @method static mixed dispatchNow(TenantWithDatabase $tenant)
     * @method static mixed dispatchSync(TenantWithDatabase $tenant)
     */
    class TenantDomainCreateJob {}
    
    /**
     * @method static PendingDispatch dispatch(TenantWithDatabase $tenant)
     * @method static mixed dispatchNow(TenantWithDatabase $tenant)
     * @method static mixed dispatchSync(TenantWithDatabase $tenant)
     */
    class TenantFileSycnForNewTenant {}
    
    /**
     * @method static PendingDispatch dispatch(TenantWithDatabase $tenant)
     * @method static mixed dispatchNow(TenantWithDatabase $tenant)
     * @method static mixed dispatchSync(TenantWithDatabase $tenant)
     */
    class TenantInformationUpdateJob {}
    
    /**
     * @method static PendingDispatch dispatch(TenantWithDatabase $tenant)
     * @method static mixed dispatchNow(TenantWithDatabase $tenant)
     * @method static mixed dispatchSync(TenantWithDatabase $tenant)
     */
    class TenantMigrateDatabseJob {}
    
    /**
     * @method static PendingDispatch dispatch(TenantWithDatabase $tenant)
     * @method static mixed dispatchNow(TenantWithDatabase $tenant)
     * @method static mixed dispatchSync(TenantWithDatabase $tenant)
     */
    class TenantSeedDatabaseJob {}
}

namespace Illuminate\Foundation\Console {

    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch(array $data)
     * @method static mixed dispatchNow(array $data)
     * @method static mixed dispatchSync(array $data)
     */
    class QueuedCommand {}
}

namespace Illuminate\Foundation\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch(array $stubs)
     * @method static PendingBroadcast broadcast(array $stubs)
     */
    class PublishingStubs {}
}

namespace Illuminate\Queue {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Laravel\SerializableClosure\SerializableClosure;
    
    /**
     * @method static PendingDispatch dispatch(SerializableClosure $closure)
     * @method static mixed dispatchNow(SerializableClosure $closure)
     * @method static mixed dispatchSync(SerializableClosure $closure)
     */
    class CallQueuedClosure {}
}

namespace Laravel\Telescope\Jobs {

    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch($pendingUpdates, int $attempt = 0)
     * @method static mixed dispatchNow($pendingUpdates, int $attempt = 0)
     * @method static mixed dispatchSync($pendingUpdates, int $attempt = 0)
     */
    class ProcessPendingUpdates {}
}

namespace Modules\WebHook\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch($current_event, $payload)
     * @method static PendingBroadcast broadcast($current_event, $payload)
     */
    class WebhookEventFire {}
}

namespace Stancl\Tenancy\Jobs {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Stancl\Tenancy\Contracts\TenantWithDatabase;
    
    /**
     * @method static PendingDispatch dispatch(TenantWithDatabase $tenant)
     * @method static mixed dispatchNow(TenantWithDatabase $tenant)
     * @method static mixed dispatchSync(TenantWithDatabase $tenant)
     */
    class CreateDatabase {}
    
    /**
     * @method static PendingDispatch dispatch(TenantWithDatabase $tenant)
     * @method static mixed dispatchNow(TenantWithDatabase $tenant)
     * @method static mixed dispatchSync(TenantWithDatabase $tenant)
     */
    class DeleteDatabase {}
    
    /**
     * @method static PendingDispatch dispatch(TenantWithDatabase $tenant)
     * @method static mixed dispatchNow(TenantWithDatabase $tenant)
     * @method static mixed dispatchSync(TenantWithDatabase $tenant)
     */
    class MigrateDatabase {}
    
    /**
     * @method static PendingDispatch dispatch(TenantWithDatabase $tenant)
     * @method static mixed dispatchNow(TenantWithDatabase $tenant)
     * @method static mixed dispatchSync(TenantWithDatabase $tenant)
     */
    class SeedDatabase {}
}

namespace Tzsk\Payu\Events {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Tzsk\Payu\Models\PayuTransaction;
    
    /**
     * @method static PendingDispatch dispatch(PayuTransaction $transaction)
     * @method static mixed dispatchNow(PayuTransaction $transaction)
     * @method static mixed dispatchSync(PayuTransaction $transaction)
     */
    class TransactionFailed {}
    
    /**
     * @method static PendingDispatch dispatch(PayuTransaction $transaction)
     * @method static mixed dispatchNow(PayuTransaction $transaction)
     * @method static mixed dispatchSync(PayuTransaction $transaction)
     */
    class TransactionInitiated {}
    
    /**
     * @method static PendingDispatch dispatch(PayuTransaction $transaction)
     * @method static mixed dispatchNow(PayuTransaction $transaction)
     * @method static mixed dispatchSync(PayuTransaction $transaction)
     */
    class TransactionInvalidated {}
    
    /**
     * @method static PendingDispatch dispatch(PayuTransaction $transaction)
     * @method static mixed dispatchNow(PayuTransaction $transaction)
     * @method static mixed dispatchSync(PayuTransaction $transaction)
     */
    class TransactionSuccessful {}
}

namespace Tzsk\Payu\Jobs {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Tzsk\Payu\Models\PayuTransaction;
    
    /**
     * @method static PendingDispatch dispatch(PayuTransaction $transaction)
     * @method static mixed dispatchNow(PayuTransaction $transaction)
     * @method static mixed dispatchSync(PayuTransaction $transaction)
     */
    class VerifyTransaction {}
}
